import { handleActions } from "redux-actions";
import {
    setLtpResultId,
    resetLtp,
    toggleLtpFilter,
    applyLtpFilter,
    clearLtpFilter,
    requestLtpResult,
    receiveLtpResult,
    failedLtpResult,
    requestLtpHistory,
    receiveLtpHistory,
    failedLtpHistory,
    requestLtpProgress,
    receiveLtpProgress,
    failedLtpProgress,
} from "store/actions/ltp";

const DEFAULT_FILTER = {
    Limit: 25,
    FromEventTs: "",
    ToEventTs: "",
    IdFilter: "",
    IdTypeFilter: "",
    SourceTypeFilter: "",
    DescriptionFilter: "",
    AdditionalDescriptionFilter: "",
};

const DEFAULT_STATE = {
    isTableLoading: false,
    isHistoryLoading: false,
    isFilterOpen: false,
    data: {},
    filter: DEFAULT_FILTER,
    resultId: null,
    allResultIdList: [],
    error: null,
    isProgressLoading: false,
    progress: {},
    fromDate: "",
    toDate: "",
    id: null,
    idType: null,
};

export const ltpResultReducer = handleActions(
    {
        [setLtpResultId]: (state, { payload }) => ({
            ...state,
            resultId: payload.resultId,
            fromDate: payload.fromDate,
            toDate: payload.toDate,
            id: payload.id,
            idType: payload.idType,
        }),
        [resetLtp]: () => ({
            ...DEFAULT_STATE,
        }),
        [toggleLtpFilter]: (state) => ({
            ...state,
            isFilterOpen: !state.isFilterOpen,
        }),
        [applyLtpFilter]: (state, { payload }) => ({
            ...state,
            filter: {
                ...DEFAULT_FILTER,
                ...payload,
            },
        }),
        [clearLtpFilter]: (state) => ({
            ...state,
            filter: {
                ...DEFAULT_FILTER,
            },
        }),
        [requestLtpResult]: (state) => ({
            ...state,
            isTableLoading: true,
            error: null,
        }),
        [receiveLtpResult]: (state, { payload }) => ({
            ...state,
            isTableLoading: false,
            data: payload,
            error: null,
        }),
        [failedLtpResult]: (_state, { payload }) => ({
            ...DEFAULT_STATE,
            error: payload,
        }),
        [requestLtpHistory]: (state) => ({
            ...state,
            isHistoryLoading: true,
            error: null,
        }),
        [receiveLtpHistory]: (state, { payload }) => ({
            ...state,
            allResultIdList: payload,
            isHistoryLoading: false,
            error: null,
        }),
        [failedLtpHistory]: (_state, { payload }) => ({
            ...DEFAULT_STATE,
            error: payload,
        }),
        [requestLtpProgress]: (state) => ({
            ...state,
            isProgressLoading: true,
            error: null,
        }),
        [receiveLtpProgress]: (state, { payload }) => ({
            ...state,
            progress: payload,
            isProgressLoading: false,
            error: null,
        }),
        [failedLtpProgress]: (_state, { payload }) => ({
            ...DEFAULT_STATE,
            error: payload,
        }),
    },
    DEFAULT_STATE
);
