import { handleActions } from "redux-actions";
import {
    failedSearchResults,
    failSingleIdInfo,
    receiveSearchResults,
    receiveSingleIdInfo,
    requestSearchResults,
    requestSingleIdInfo,
    requestSearchExamples,
    receiveSearchExamples,
    failedSearchExamples,
} from "store/actions/search";

const DEFAULT_STATE = {
    loading: false,
    payload: {},
    error: null,
};

export const searchResult = handleActions(
    {
        [requestSearchResults]: (state) => ({
            loading: true,
            payload: {},
            error: null,
        }),
        [receiveSearchResults]: (state, { payload }) => ({
            loading: false,
            payload,
            error: null,
        }),
        [failedSearchResults]: (state, { payload }) => ({
            loading: false,
            payload: {},
            error: payload,
        }),
    },
    DEFAULT_STATE
);

export const searchExamples = handleActions(
    {
        [requestSearchExamples]: (state) => ({
            loading: true,
            payload: {},
            error: null,
        }),
        [receiveSearchExamples]: (state, { payload }) => ({
            loading: false,
            payload,
            error: null,
        }),
        [failedSearchExamples]: (state, { payload }) => ({
            loading: false,
            payload: {},
            error: payload,
        }),
    },
    DEFAULT_STATE
);

export const specialSearchResult = handleActions(
    {
        [requestSingleIdInfo]: (state) => ({
            loading: true,
            payload: {},
            error: null,
        }),
        [receiveSingleIdInfo]: (state, { payload }) => ({
            loading: false,
            payload,
            error: null,
        }),
        [failSingleIdInfo]: (state, { payload }) => ({
            loading: false,
            payload: {},
            error: payload,
        }),
    },
    DEFAULT_STATE
);
