import { createSelector } from "reselect";

export const getLtp = (state) => state.ltp;

export const isLtpLoading = createSelector(
    [getLtp],
    ({ isTableLoading, isHistoryLoading }) => isTableLoading && isHistoryLoading,
);

export const isLtpFilterOpen = createSelector(
    [getLtp],
    ({ isFilterOpen }) => isFilterOpen,
);

export const ltpFilterForm = createSelector(
    [getLtp],
    ({ filter }) => filter,
);
