import { createSelector } from "reselect";
import { parse } from "query-string";

const getLocation = (state) => {
    return state.router.location;
};

export const getSearchObject = createSelector(
    [getLocation],
    (location) => parse(location.search)
);

export const getQuery = createSelector(
    [getSearchObject],
    (search) => {
        let query = '';

        if (Array.isArray(search.query)) {
            query = search.query.join('');
        }

        if (typeof search.query === 'string') {
            query = search.query;
        }

        return query.trim();
    },
);
