const path = require('path');
const { merge } = require('webpack-merge');
const CopyPlugin = require("copy-webpack-plugin");
const CaseSensitivePathsPlugin = require("case-sensitive-paths-webpack-plugin");
const common = require('./webpack.common.js');

const { HOST, PORT, CERT } = process.env;

const ROOT_DIR = process.cwd();
const BUILD_DIR = path.join(ROOT_DIR, 'build');
const PUBLIC_DIR = path.join(ROOT_DIR, 'public');
const CERT_PATH = path.join(ROOT_DIR, CERT);

class CleanUpStatsPlugin {
    shouldPickStatChild(child) {
        return child.name.indexOf("mini-css-extract-plugin") !== 0;
    }

    apply(compiler) {
        compiler.hooks.done.tap("CleanUpStatsPlugin", (stats) => {
            const children = stats.compilation.children;
            if (Array.isArray(children)) {
                stats.compilation.children = children.filter((child) =>
                this.shouldPickStatChild(child)
                );
            }
        });
    }
}

module.exports = merge(common, {
    mode: 'development',
    devtool: 'source-map',
    stats: 'minimal',
    devServer: {
        port: PORT,
        historyApiFallback: true,
        hot: true,
        https: {
            key: CERT_PATH,
            cert: CERT_PATH,
            ca: CERT_PATH,
        },
        compress: true,
        disableHostCheck: true,
        host: HOST,
    },
    plugins: [
        new CopyPlugin({
            patterns: [
                {
                    from: path.join(PUBLIC_DIR, 'env.json'),
                    to: BUILD_DIR,
                },
            ],
        }),
        new CleanUpStatsPlugin(),
        new CaseSensitivePathsPlugin(),
    ],
});
