class BsInfoClient:
    def __init__(self, config, session_pool, logger):
        self.config = config
        self.session_pool = session_pool
        self.logger = logger

    def get_candidates(self, hit_log_id):
        candidates = None

        try:
            url = "{}/why_this_ad/api/get_stat_mx_features_log/{}".format(self.config.Url, hit_log_id)
            session = self.session_pool.get_session()
            self.logger.info("GET %s", url)
            response = session.get(url)
            response.raise_for_status()
            candidates = response.json()
            candidates.sort(key=lambda x: -x["StatValue"])
            candidates = candidates[:self.config.MaxCandidates]
        except Exception:
            self.logger.exception("")

        return candidates
