from library.python.protobuf.json import json2proto

from crypta.lib.python import http_client_utils
from crypta.search.proto import search_pb2


class SearchClient:
    def __init__(self, config, session_pool, logger):
        self.url = config.Url
        self.headers = {
            "Authorization": "OAuth {}".format(config.Token)
        }
        self.session_pool = session_pool
        self.logger = logger

    @http_client_utils.with_protobuf_response(search_pb2.TResultResponse, json2proto.Json2ProtoConfig(map_as_object=True))
    def search(self, query, matcher=None):
        self.logger.info("Search '%s'", query)
        params = {
            "query": query,
        }

        if matcher is not None:
            params["matcher"] = matcher

        session = self.session_pool.get_session()
        response = session.get(self.url + "/search", params=params, headers=self.headers)
        self.logger.info(
            "Request [%s] for %s got %s",
            response.headers.get('X-Crypta-Request-ID', 'NO-ID'),
            response.request.url,
            response.status_code,
        )
        return response
