import cachetools


class StaffClient:
    def __init__(self, config, session_pool, logger):
        self.url = "https://{}/v3/persons".format(config.Url)
        self.headers = {
            "Authorization": "OAuth {}".format(config.Token),
        }
        self.logger = logger
        self.session_pool = session_pool

    @cachetools.cached(cache=cachetools.TTLCache(maxsize=4096, ttl=900))
    def get_staff_login(self, tg_login):
        self.logger.info("Get staff login for %s", tg_login)
        staff_login = None

        if tg_login is not None:
            login_field = "login"
            params = {
                "_query": '(official.is_dismissed == False) and (is_deleted == False) and (accounts == match({{"type": "telegram", "value_lower": "{}"}}))'.format(tg_login.lower()),
                "_one": 1,
                "_fields": login_field,
            }

            session = self.session_pool.get_session()
            try:
                response = session.get(url=self.url, headers=self.headers, params=params)
                response.raise_for_status()
                staff_login = response.json()[login_field]
            except Exception:
                self.logger.exception("")

        self.logger.info("Staff login for %s is %s", tg_login, staff_login)

        return staff_login
