from typing import List, Optional, Union
from pydantic import BaseModel


class Message(BaseModel):
    author: str = "пользователь"
    text: str = ""


class InputRequest(BaseModel):
    model_name: str
    messages: Optional[List[Message]]
    text: Optional[str] = ""
    custom_embedder_api_url: Optional[str] = None


class ErrorResponse(BaseModel):
    passed: bool
    message: str


class KnowledgeMeta(BaseModel):
    local_id: Union[int, List[int]]
    probability: Union[float, List[float]]
    url: Optional[str]
    title: Optional[str]
    content: Optional[str]


class ClassifyResponse(BaseModel):
    input_text: str
    embedding: List[float]
    predicted_class: str


class LoggedRow(BaseModel):
    # Which model is used
    model_name: str

    # Input request to full api
    messages: Optional[List[Message]]
    text: Optional[str] = ""

    # Output response from full api
    prefix: str
    answer: str
    knowledge: KnowledgeMeta

    # Data from chat page
    ticket_id: str
    fixed_answer: str
