import sys
import json
from customer_service.ml.lib.data.knowledges import prepare_actual_knowledges, map_knowledges

actual_knowledges = prepare_actual_knowledges('support-private',
                                              'knowledge-base/snapshots/snapshot_2022-02-22.gz',
                                              'station')

for line in sys.stdin:
    row = json.loads(line)
    row = map_knowledges(row, actual_knowledges)
    sys.stdout.write(json.dumps(row) + '\n')

