import click
import logging
from customer_service.ml.lib.data.utils import (
    get_secret_uuid,
    get_yql_client,
    execute_query
)

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


@click.command()
@click.option('--input_data', required=True, help='Path to input dataset in YT')
@click.option('--output_data', required=True, help='Path to output dataset in YT')
@click.option('--yql_query_file', default='chats/data/yql/preprocess.sql', help='Path to query template')
@click.option('--yql_alias', default='customer-service-yql', help='Alias for YQL in yandex vault')
def main(input_data: str,
         output_data: str,
         yql_query_file: str,
         yql_alias: str):

    params = {
        'input_path': input_data,
        'output_path': output_data,
    }

    _, token = get_secret_uuid(yql_alias, 'YQL_TOKEN')
    client = get_yql_client(token)
    logger.info(f'Preprocessing raw data from {input_data} to {output_data}')
    execute_query(client, query_file=yql_query_file, templating=params)


if __name__ == '__main__':
    main()