import click
import logging
from customer_service.ml.lib.data.knowledges import convert_cases_from_xlsx_to_yt


logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


@click.command()
@click.option('--filepath', required=True, help='Path to xlsx file on YT')
@click.option('--source_table', required=True, help='Path to YT table for remapping')
@click.option('--destination_table', required=True, help='Path to YT table to save remapped data')
@click.option('--col_url',  default='knowledge_id', help='Column name with knowledge url')
@click.option('--cluster', default='hahn', help='YT cluster name')
def main(filepath: str, source_table: str, destination_table: str, col_url: str, cluster: str):
    logging.info(f"Reducing label cases in table {source_table}")
    convert_cases_from_xlsx_to_yt(filepath, destination_table)
    logging.info(f"Saved to {destination_table}")


if __name__ == '__main__':
    main()
