import click
import logging
from customer_service.ml.lib.data.knowledges import KnowledgesRemapper

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


@click.command()
@click.option('--filepath', required=True, help='Path to xlsx file on YT')
@click.option('--source_table', required=True, help='Path to YT table for remapping')
@click.option('--destination_table', required=True, help='Path to YT table to save remapped data')
@click.option('--col_url',  default='knowledge_id', help='Column name with knowledge url')
@click.option('--col_text', default='know', help='Column name with knowledge text')
@click.option('--cluster', default='hahn', help='YT cluster name')
def main(filepath: str, source_table: str, destination_table: str, col_url: str, col_text: str, cluster: str):
    logging.info(f"Remapping knowledges in table {source_table}")

    know_remap = KnowledgesRemapper(proxy=cluster)
    know_remap.create_remapper_from_xlsx(filepath)
    know_remap.remap_knowledges(source_table, destination_table, col_url, col_text)

    logging.info(f"Saved to {destination_table}")


if __name__ == '__main__':
    main()
