USE hahn;
PRAGMA yson.DisableStrict;
PRAGMA yt.staticPool = "sup_tech";
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- params
$input = '{input_path}';
$output = '{output_path}';
$start_date = '{start_date}';
$stop_date = '{stop_date}';
$queues_str = '{queues}';

$start_ts = DateTime::ToMilliseconds(CAST($start_date AS DATE));
$stop_ts = DateTime::ToMilliseconds(CAST($stop_date AS DATE));

$queues =
    String::SplitToList(
        String::RemoveLast(
            String::RemoveFirst($queues_str, '['),
            ']'
        ),
        ', '
    );

INSERT INTO $output WITH TRUNCATE
SELECT
    ticketId,
    ticket,
    articleId,
    article,
    Yson::ConvertToString(article.customData.floydRole) AS author,
    Yson::ConvertToString(article.body) AS message,
    CAST(
        DateTime::FromMilliseconds(
            CAST(
                Yson::ConvertToInt64(tickets.`article`.createdTs) AS Uint64)
            ) AS String)
        AS messageTime,
    CAST(Yson::ConvertToInt64(`article`.createdTs) AS Uint64) as messageTs,
    exportedAt,
    Yson::ConvertToString(Yson::ConvertToList(ticket.linkedKnowledges)[0].knowledgeCluster) AS cluster,
    Yson::ConvertToString(Yson::ConvertToList(ticket.linkedKnowledges)[0].knowledgeId) AS knowledgeId,
    Yson::ConvertToString(Yson::ConvertToList(ticket.linkedKnowledges)[0].knowledgeTitle) AS knowledgeTitle,
FROM $input AS tickets
WHERE
      Yson::ConvertToInt64(ticket.createdTs) > $start_ts  AND
      Yson::ConvertToInt64(ticket.createdTs) < $stop_ts  AND
      Yson::ConvertToString(ticket.channel) == "FLOYD" AND
      Yson::ConvertToString(ticket.queueDetails.queueId) IN $queues AND
      Yson::ConvertToString(article.customData.floydRole) != "bot" AND
      Yson::ConvertToString(article.body) != "" AND
      Yson::ConvertToString(article.body) NOT REGEXP 'Автоназначение\|Позвать оператора\|service' AND
      ListLength(Yson::ConvertToList(ticket.linkedKnowledges)) == 1
ORDER BY ticketId, messageTs;
