USE hahn;
PRAGMA yson.DisableStrict;
PRAGMA yt.staticPool = "sup_tech";
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- params
$input = '{input_path}';
$output = '{output_path}';

$min_ts = (
    SELECT DISTINCT ticketId, MIN(messageTs) as minTs
    FROM $input
    GROUP BY ticketId
);

$min_ts_operator = (
    SELECT DISTINCT ticketId, MIN(messageTs) as minOpTs
    FROM $input
    WHERE author == "operator"
    GROUP BY ticketId
);

$data_filter = (
    SELECT a.*, b.* FROM $input as a
    LEFT JOIN (
        SELECT DISTINCT l.ticketId as ticketId, l.minTs as minTs, r.minOpTs as minOpTs
        FROM $min_ts as l
        LEFT JOIN $min_ts_operator as r
        ON (l.ticketId == r.ticketId)
    ) as b
    ON a.ticketId == b.ticketId
);

$data = (
    SELECT * FROM $data_filter
    WHERE NOT (minTs == minOpTs AND messageTs == minOpTs)
);

$lower_bound = (
    SELECT l.*, r.lbTs as lbTs from $data as l
    LEFT JOIN (
        SELECT DISTINCT ticketId, MIN(messageTs) as lbTs
        FROM $data
        WHERE author == "operator"
        GROUP BY ticketId
    ) as r
    USING (ticketId)
);

$cut = (
    SELECT * from $lower_bound
    WHERE messageTs < lbTs AND
          message NOT REGEXP 'Нужен человек\|Позвать оператора\|Позови человека\|Прохождение модерации'
);

$agg = (
    SELECT ticketId,
           AGGREGATE_LIST_DISTINCT(message) as listMsg,
           SOME(knowledgeId) as knowledgeId,
           SOME(knowledgeTitle) as knowledgeTitle,
           MIN(messageTs) as messageTs,
           MIN(messageTime) as messageTime
    FROM $cut
    GROUP BY ticketId
);

INSERT INTO $output WITH TRUNCATE
SELECT ticketId, ListConcat(listMsg, "\n") as text, knowledgeId, knowledgeTitle, messageTs, messageTime
FROM $agg
ORDER BY ticketId, messageTs;
