import click
import logging
import pandas as pd
from collections import defaultdict
from dataclasses import asdict
from customer_service.ml.chats.zeliboba.lib.metrics import get_metrics
from customer_service.ml.lib.data.utils import save_data

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


@click.command()
@click.option('--data_train', required=False, help='Path to YT train dataset with predictions')
@click.option('--data_val', required=False, help='Path to YT val dataset with predictions')
@click.option('--data_test', required=True, help='Path to YT test dataset with predictions')
@click.option('--output_path', required=True, help='Path to YT directory to store metrics')
@click.option('--target_col', default='y_true', help='Name of column with ground truth values')
@click.option('--predict_col', default='y_pred', help='Name of column with predicted values')
def main(data_train: str,
         data_val: str,
         data_test: str,
         output_path: str,
         target_col: str,
         predict_col: str):

    logger.info('Calculating metrics')
    metrics = defaultdict(list)
    for split, data_path in zip(
            ['train', 'val', 'test'],
            [data_train, data_val, data_test]
            ):

        if data_path:
            metrics_ = asdict(
                get_metrics(data_path, target_col, predict_col)
            )
            metrics['split'].append(split)
            for k, v in metrics_.items():
                metrics[k].append(v)

    save_data(pd.DataFrame(metrics), output_path)


if __name__ == '__main__':
    main()
