import os
from datacloud.config.token_names import AUDIENCE_TOKEN_NAME
from datacloud.config.robots import AUDIENCE_ROBOT_NAME
from datacloud.audience.lib import utils
from datacloud.dev_utils.yt import yt_utils
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.audience.lib.api import AudienceApi


logger = get_basic_logger(__name__)


def main():
    yt_client = yt_utils.get_yt_client()
    token = os.environ.get(AUDIENCE_TOKEN_NAME)
    assert token
    api = AudienceApi(yt_client, AUDIENCE_ROBOT_NAME, token)

    table = '//projects/scoring/tmp/prod-tmp/audience/internal-internal_xprod_1467-2019-10-29-0.9-1.0-4'

    data = utils.download_segment(yt_client, table)

    # replace segment
    segment_id = '11901979'
    resp = api.replace_id_values(segment_id, data)
    logger.info('resp is: {}'.format(resp))
    return

    # create new segment
    resp = api.upload_id_values(data)
    segment_id = api.get_segment_id_from_response(resp)
    logger.info('Segment id', api.get_segment_id_from_response(resp))
    api.confirm(segment_id, 'wow such new segment')


if __name__ == '__main__':
    main()
