from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.yt import yt_config_table


logger = get_basic_logger()
DEFAULT_AUDIENCE_EVENT_LOG_TABLE = ''


class AudienceEventLogTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=DEFAULT_AUDIENCE_EVENT_LOG_TABLE, yt_client=None):
        schema = [
            {'name': 'partner_id', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'audience_name', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'date_str', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'additional', 'type': 'any'}
        ]
        super(AudienceEventLogTable, self).__init__(
            table_path, schema, yt_client
        )

        def add_event(self, partner_id, audience_name, date_str, additional=None):
            additional = additional or {}
            record = {
                'partner_id': partner_id,
                'audience_name': audience_name,
                'date_str': date_str,
                'additional': additional
            }
            self.insert_records([record])
