from datacloud.dev_utils.yt import yt_utils
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.batch.lib.storage import FtpStorage, YtTableStorage


logger = get_basic_logger(__name__)


def use_storage(storage):
    logger.info(storage.list('/'))
    tmp_file = '//tmp/cache.md'
    storage.retrieve('/tests/cache.md', tmp_file)

    folder_to_create = '//tests/inner-folder'
    if not storage.is_exist(folder_to_create):
        storage.mkdir(folder_to_create)
    else:
        logger.info('Folder alredy exist')
    upload_to = folder_to_create + '/sample-upload'
    if not storage.is_exist(upload_to):
        storage.store(upload_to, tmp_file)
    else:
        logger.info('Nothing to upload, already done')
    logger.info('Done')


def check_yt_table_storage():
    storage = YtTableStorage(yt_utils.get_yt_client())

    storage_path = '//tmp/sample-data-r9'
    local_path = '//tmp/sample_data.csv'
    storage.retrieve(storage_path, local_path)

    new_storage_path = '//tmp/sample-data-r9-v2'
    storage.store(new_storage_path, local_path)


def main():
    check_yt_table_storage()
    return
    host = 'ftp.yandex.net'
    login = ''
    passwd = ''
    storage = FtpStorage(host, login, passwd)
    use_storage(storage)


if __name__ == '__main__':
    main()
