


class Monitor(object):
    def __init__(self, storage, name_filter=None):
        self._storage = storage
        self._filter = name_filter

    def get_items(self, folder, absolute=False):
        items = list(filter(self._filter, self._storage.list(folder)))
        if absolute:
            folder = folder.rstrip('/')
            items = [folder + '/' + item for item in items]
        return items
