import csv
from datacloud.dev_utils.validators.csv_validator import (
    CSVValidator, RecordError)


def has_all_fields(rec):
    valid = rec.get('external_id') and rec.get('id_value') and rec.get('id_type')
    if not valid:
        raise RecordError('EX8', 'Empty field found')


def check_id_value(rec):
    val = rec.get('id_value', '')
    if not val:
        raise RecordError('EX8', 'Empty id_value field')
    if len(val) != 32:
        raise RecordError('EX8', 'Wrong md5 hash length')


def check_external_id(rec):
    val = rec.get('external_id', '')
    if not val:
        raise RecordError('EX8', 'Empty external_id')
    if len(val) > 50:
        raise RecordError('EX8', 'Too long external_id, max_len=50')


def check_id_type(rec):
    val = rec.get('id_type', '')
    if val not in ('phone_md5', 'email_md5'):
        raise RecordError('EX8', 'Wrong id_type')


def validate(file_handler):
    field_names = ('external_id', 'id_value', 'id_type')
    validator = CSVValidator(field_names)

    validator.add_header_check('EX1', 'bad header')
    validator.add_record_check(has_all_fields)
    validator.add_record_check(check_id_value)
    validator.add_record_check(check_external_id)
    validator.add_record_check(check_id_type)

    data = csv.reader(file_handler)
    problems = validator.validate(data)

    broken_rows = set()
    for problem in problems:
        broken_rows.add(problem['row'])

    return broken_rows, problems
