# -*- coding: utf-8 -*-
import argparse
from datacloud.dev_utils.time.utils import now_str
from datacloud.dev_utils.status_db.task import Task, Status
from datacloud.dev_utils.status_db.db import StatusDB

COMMAND_SEPRARATOR = '#'


def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-p', '--partner-id', help='<Required> Partner ID', required=True)
    parser.add_argument('-s', '--score-name', help='<Required> Score name', required=True)
    parser.add_argument('-d', '--date-str', help='<Required> Date Str', required=True)
    args = parser.parse_args()

    return args.partner_id, args.score_name, args.date_str


def build_command(partner_id, score_name):
    return COMMAND_SEPRARATOR.join(['run_model', partner_id, score_name])


def main():
    partner_id, score_name, date_str = get_args()

    current_time = now_str()
    command = build_command(partner_id, score_name)
    task = Task(command, date_str, Status.READY,
                {'date_str': date_str}, current_time, current_time)
    StatusDB().add_task(task)


if __name__ == '__main__':
    main()
