# -*- coding: utf-8 -*-
import argparse
from datacloud.dev_utils.time.utils import now_str
from datacloud.dev_utils.status_db.task import Task, Status
from datacloud.dev_utils.status_db.db import StatusDB

COMMAND_SEPRARATOR = '#'


def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-p', '--partner-id', help='<Required> Partner ID', required=True)
    parser.add_argument('-s', '--score-name', help='<Required> Score name', required=True)
    parser.add_argument('-d', '--date-str', help='<Required> Date Str', required=True)
    args = parser.parse_args()

    return args.partner_id, args.score_name, args.date_str


def main():
    partner_id, score_name, date_str = get_args()

    current_time = now_str()
    transfer_key = COMMAND_SEPRARATOR.join(['cli', partner_id, score_name, date_str])
    task = Task(
        'check_models_stability', transfer_key, Status.READY,
        {
            'partner_id': partner_id,
            'score_name': score_name,
            'date_str': date_str,
        },
        current_time, current_time)

    StatusDB().add_task(task)


if __name__ == '__main__':
    main()
