# -*- coding: utf-8 -*-
from datacloud.dev_utils.id_value.id_value_lib import count_md5


class BatchMapper:
    def __init__(self, target_name):
        self.target_name = target_name

    def __call__(self, rec):
        id_values = []
        if rec.get('email_id_value'):
            id_values.append(rec['email_id_value'])
        elif rec.get('email'):
            id_values.append(count_md5(rec['email']))

        if rec.get('phone_id_value'):
            id_values.append(rec['phone_id_value'])
        elif rec.get('phone'):
            id_values.append(count_md5(rec['phone']))

        for id_value in id_values:
            target = int(rec[self.target_name])
            if target >= 0:
                yield {
                    'id_value': id_value,
                    'external_id': rec['external_id'],
                    'target': target
                }
