import gunicorn.app.base
from datacloud.control.lib import api


class GunicornApp(gunicorn.app.base.BaseApplication):
    def __init__(self, flask_app, host, port, workers, timeout):
        self.flask_app = flask_app
        self.host = host
        self.port = port
        self.workers = workers
        self.timeout = timeout
        super(GunicornApp, self).__init__()

    def load_config(self):
        self.cfg.set('workers', self.workers)
        self.cfg.set('bind', '{}:{}'.format(self.host, self.port))
        self.cfg.set('timeout', self.timeout)

    def load(self):
        return self.flask_app


if __name__ == '__main__':
    port = 8888
    timeout = 10
    workers = 1
    app = GunicornApp(
        api.get_app(),
        host='[::]',
        port=port,
        workers=workers,
        timeout=timeout
    )
    app.run()
