import logging
from enum import Enum, unique


__all__ = [
    # 'get_constant',  # compatibility mode
    'InMemoryMode',
    'ErasureCodec',
    'CompressionCodec',
    'YtCluster',
    'ReplicaState',
    'TabletState',
    'OptimizeFor',
]


logger = logging.getLogger(__name__)


# def get_constant(val):
#     if val is None:
#         return val
#     if isinstance(val, Enum):
#         return val
#     if isinstance(val, (str, unicode)):
#         all_constants = [YtCluster, ErasureCodec, CompressionCodec]
#         all_keys = {}
#         for enum in all_constants:
#             for item in enum.__members__.values():
#                 all_keys[item.value] = item
#         if val not in all_keys:
#             raise ValueError('Unknown constant %r' % val)
#         constant = all_keys[val]
#         logger.warning('Using string constants is deprecated (%r interpreted as %s)', val, constant)
#         return constant
#     raise ValueError('Unexpected error')


@unique
class InMemoryMode(Enum):
    UNCOMPRESSED = 'uncompressed'
    COMPRESSED = 'compressed'
    NONE = 'none'


@unique
class ErasureCodec(Enum):
    NONE = 'none'
    lrc_12_2_2 = 'lrc_12_2_2'


@unique
class CompressionCodec(Enum):
    LZ4 = 'lz4'
    brotli_6 = 'brotli_6'
    brotli_8 = 'brotli_8'
    zstd_6 = 'zstd_6'
    zstd_9 = 'zstd_9'


@unique
class YtCluster(Enum):
    HAHN = 'hahn'
    BANACH = 'banach'
    MARKOV = 'markov'
    SENECA_MAN = 'seneca-man'
    SENECA_MYT = 'seneca-myt'
    SENECA_SAS = 'seneca-sas'
    SENECA_VLA = 'seneca-vla'


@unique
class ReplicaState(Enum):
    ENABLED = 'enabled'
    ENABLING = 'enabling'
    DISABLED = 'disabled'
    DISABLING = 'disabling'


@unique
class TabletState(Enum):
    MOUNTED = 'mounted'
    MOUNTING = 'mounting'
    UNMOUNTED = 'unmounted'
    UNMOUNTING = 'unmounting'
    FROZEN = 'frozen'
    FREZING = 'frezing'


@unique
class OptimizeFor(Enum):
    LOOKUP = 'lookup'
    SCAN = 'scan'
