import os

from .constants import YtCluster

__all__ = [
    'get_best_cluster',
]


QLOUD_YT_CLUSTERS = {
    'MAN': YtCluster.SENECA_MAN,
    'MYT': YtCluster.SENECA_MYT,
    'SAS': YtCluster.SENECA_SAS,
    'VLA': YtCluster.SENECA_VLA
}


def get_best_cluster():
    """ Selects best YT cluster """
    qloud_datacenter = os.environ.get('QLOUD_DATACENTER', None)
    closest_yt_cluster = QLOUD_YT_CLUSTERS.get(qloud_datacenter, YtCluster.SENECA_SAS)
    return closest_yt_cluster
