

__all__ = [
    'StateDifference',
]


class StateDifference(object):
    """ Some difference of table actual state and described schema """
    _msg_templ = None

    def __init__(self, table):
        super(StateDifference, self).__init__()
        self._table = table

    @property
    def actions(self):
        """ Iterates over actions for removing the difference """
        raise NotImplementedError()

    def _get_pretty_args(self):
        return {'path': self._table.path}

    @property
    def pretty_msg(self):
        """ Returns human-readable string for describing the difference """
        if self._msg_templ is not None:
            args = self._get_pretty_args()
            return self._msg_templ % args
        raise NotImplementedError()
