from .generic import StateDifference
from .actions import ConvertToReplicated, Unmount, ManuallyResolve, Remove


__all__ = [
    'NotReplicated',
    'MultipleSecondaryConflict',
    'RedundantSecondary',
]


class NotReplicated(StateDifference):
    _msg_templ = '%(path)s is not replicated table'

    def __init__(self, table, exist_table, **kwargs):
        super(NotReplicated, self).__init__(table, **kwargs)
        self._source = exist_table

    @property
    def actions(self):
        yield ConvertToReplicated(self._table, source_table=self._source)


class MultipleSecondaryConflict(StateDifference):
    _msg_templ = '%(path)s is not replicated table and has multiple independent secondary tables'

    @property
    def actions(self):
        yield ManuallyResolve(self._table)


class RedundantSecondary(StateDifference):
    _msg_templ = 'replica %(path)s to %(cluster)s is redundant'

    @property
    def actions(self):
        yield Unmount(self._table)
        yield Remove(self._table)
