#include <util/generic/string.h>
#include <util/generic/strbuf.h>
#include <util/generic/vector.h>

namespace DataCloud {

TVector<float> FromString(const TString& binaryString) {
    assert(binaryString.size() % 4 == 0);
    const char* buffer = binaryString.c_str();
    const i32 nElems = binaryString.size() / 4;
    TVector<float> data(nElems);
    float val;
    for (int idx = 0; idx < nElems; ++idx) {
        memcpy(&val, buffer + (idx * 4), sizeof(float));
        data[idx] = val;
    }
    return data;
}

TString ToString(const TVector<float>& data) {
    const i32 nElems = data.size();
    const i32 strSize = nElems * 4;
    char buffer [strSize];
    for (int idx = 0; idx < nElems; ++idx) {
        *(float*)(buffer + idx * 4) = data[idx];
    }
    return TString(buffer, strSize);
}

}  // namespace DataCloud
