# -*- coding: utf-8 -*-
import numpy as np


NP_FORMAT = '<f4'


__all__ = [
    'array_fromstring',
    'array_tostring',
    'combine_features'
]


def array_fromstring(string, dtype=NP_FORMAT):
    return np.fromstring(string, dtype=dtype)


def array_tostring(array, dtype=NP_FORMAT):
    if isinstance(array, (list, )):
        array = np.array(array)
    return array.astype(NP_FORMAT).tostring()


def combine_features(list_of_feature_lists):
    return np.hstack(list_of_feature_lists)
