# -*- coding: utf-8 -*-
from datacloud.dev_utils.logging.logger import get_basic_logger

logger = get_basic_logger(__name__)


__all__ = [
    'log_func',
]


def log_func(func):
    def ret_func(*args, **kwargs):
        logger.info(' Start {}'.format(func.__name__))
        result = func(*args, **kwargs)
        logger.info(' Done {}'.format(func.__name__))
        return result
    return ret_func
