from yt.yson import YsonUint64
from datacloud.dev_utils.id_value.id_value_lib import normalize_phone, normalize_email, encode_as_uint64, encode_hexhash_as_uint64, count_md5


__all__ = [
    'encode_phone',
    'encode_email',
    'encode_yuid',
    'encode_cid',
    'encode_cookie',
    'encode_id_value',
]


def encode_phone(phone):
    phone = normalize_phone(phone)
    return YsonUint64(encode_as_uint64(phone))


def encode_email(email):
    email = normalize_email(email)
    if email is None:
        return None
    return YsonUint64(encode_as_uint64(email))


def encode_yuid(yuid):
    return YsonUint64(encode_as_uint64('yuid:%s' % yuid))


def encode_cid(cid):
    return YsonUint64(encode_as_uint64(cid))


def partially_encode_cookie(vendor, value):
    return count_md5('cookie:%s:%s' % (vendor, value))


def encode_cookie(vendor, value):
    return YsonUint64(encode_as_uint64('cookie:%s:%s' % (vendor, value)))


def encode_id_value(id_value):
    return YsonUint64(encode_hexhash_as_uint64(id_value))
