# -*- coding: utf-8 -*-
import os
import yt.wrapper as yt_wrapper
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.config.yt import PARTNER_BINARY_MODEL_YT_PATH
from datacloud.dev_utils.yt import yt_utils
from datacloud.config.yt import YT_PROXY


logger = get_basic_logger(__name__)


if __name__ == '__main__':
    _yt_client = yt_utils.get_yt_client(YT_PROXY)
    yt_root = PARTNER_BINARY_MODEL_YT_PATH

    local_folder_with_bins = '/home/re9ulusv/dev/datacloud-features-and-scores/datacloud/models_bins/'
    partner_id = 'tcs'
    model_id = 'tcs_xprod_987_20181212'
    binary_name = '{}.pkl'.format(model_id)

    local_binary_name = os.path.join(local_folder_with_bins, partner_id, binary_name)
    yt_binary_name = yt_wrapper.ypath_join(yt_root, partner_id, model_id, binary_name)
    yt_link = yt_wrapper.ypath_join(yt_root, partner_id, model_id, 'current')

    logger.info('local binary name: {}'.format(local_binary_name))
    logger.info('yt_binary_name: {}'.format(yt_binary_name))
    logger.info('yt_link: {}'.format(yt_link))

    yt_utils.uplaod_file(local_binary_name, yt_binary_name, _yt_client)
    _yt_client.link(yt_binary_name, yt_link)
