# -*- coding: utf-8 -*-
import logging
import sys

__all__ = [
    'get_basic_logger',
    'get_nirvana_logger'
]


def get_basic_logger(name=__name__, format=None):
    logging.basicConfig()
    basic_logger = logging.getLogger(name)
    basic_logger.setLevel(logging.INFO)
    if format:
        stream_handler = logging.StreamHandler()
        stream_handler.setFormatter(logging.Formatter(format))
        basic_logger.addHandler(stream_handler)

    return basic_logger


def get_nirvana_logger(name=__name__):
    logger = get_basic_logger(name)
    ch = logging.StreamHandler(sys.stdout)
    ch.setLevel(logging.INFO)
    logger.addHandler(ch)
    return logger
