# -*- coding: utf-8 -*-
import enum
from datacloud.dev_utils.time.utils import now_str
from datacloud.dev_utils.time.utils import assert_date_str
from datacloud.dev_utils.time.patterns import RE_FMT_DATE_HMS


__all__ = [
    'Status',
    'Task'
]


class Status(enum.Enum):
    READY = 'READY'
    DONE = 'DONE'
    SKIPPED = 'SKIPPED'

    def __str__(self):
        return self.value


class Task(object):
    def __init__(self, program, key, status, data, create_time, update_time):
        """ClasterMaster task

        :param program: [description]
        :type program: str
        :param key: [description]
        :type key: str
        :param status: [description]
        :type status: Status
        :param data: [description]
        :type data: dict
        :param create_time: [description]
        :type create_time: string
        :param update_time: [description]
        :type update_time: string
        """
        status = Status(status)
        assert_date_str(create_time, RE_FMT_DATE_HMS)
        assert_date_str(update_time, RE_FMT_DATE_HMS)

        self.program = str(program)
        self.key = str(key)
        self.status = status
        self.data = data
        self.create_time = create_time
        self.update_time = update_time

    def to_json(self):
        return {
            'program': str(self.program),
            'key': str(self.key),
            'status': str(self.status),
            'data': self.data,
            'create_time': self.create_time,
            'update_time': self.update_time,
        }

    def __str__(self):
        return '{program}#{key}#{status}'.format(program=self.program, key=self.key, status=self.status)

    def make_done(self, new_status=Status.DONE, update_time=None):
        if not update_time:
            update_time = now_str()
        assert_date_str(update_time, RE_FMT_DATE_HMS)
        assert isinstance(new_status, Status), 'new_status must be instance of dev_utils.task.Status'
        self.status = new_status
        self.update_time = update_time
        return self


if __name__ == '__main__':
    task = Task('new_task', '2019-01-02', Status.READY, {'test': 'data'}, '2019-02-02', '2019-02-03')
    print(task)
