# -*- coding: utf-8 -*-
import re
from datetime import datetime, timedelta
from datacloud.dev_utils.time.patterns import RE_DAILY_LOG_FORMAT, FMT_DATE_HMS, FMT_DATE_HMST


__all__ = [
    'assert_date_str',
    'now_str'
]


def assert_date_str(date_str, pattern=RE_DAILY_LOG_FORMAT, error_msg='Wrong date format, expected: `{}`; get `{}`'):
    assert re.match(pattern, date_str), error_msg.format(pattern, date_str)


def now_str(format=FMT_DATE_HMS):
    return datetime.now().strftime(format)


def now_floor_str(format=FMT_DATE_HMST, minutes=5):
    """Round `datetime.now()` to % minutes and return in format"""
    tm = datetime.now()
    discard = timedelta(minutes=tm.minute % minutes,
                        seconds=tm.second,
                        microseconds=tm.microsecond)
    tm -= discard
    return tm.strftime(format)
