# -*- coding: utf-8 -*-
from datacloud.dev_utils.yt import yt_utils
import simplejson as json


# ammo_sample = """
# [Host: internal-datacloud.common.yandex.net]
# [Connection: close]
# [User-Agent: Tank]
# [Content-Type: application/json]
# [Authorization: xieciethiefexodieheikipiumaingaizahyabuquiokeezooreikieghangekoh]
# 98 /v1/accounts/partner_a/scores
# {"user_ids":{"emails": [{"email":"test-email@gmail.com"}]}, "scores":[{"score_name": "score_a"}]}
# """


ammo_header = """[Host: internal-datacloud.common.yandex.net]
[Connection: close]
[User-Agent: Tank]
[Content-Type: application/json]
[Authorization: xieciethiefexodieheikipiumaingaizahyabuquiokeezooreikieghangekoh]
"""

ammo_sample = """{n_bytes} /v1/accounts/partner_a/scores
{data}\n"""


def generate_ammo(yt_client, input_table, output_ammo_file):
    with open(output_ammo_file, 'w+') as fh:
        fh.write(ammo_header)
        for idx, rec in enumerate(yt_client.read_table(input_table)):
            rec['user_ids'] = rec['ids']
            del rec['ids']
            rec['scores'] = [{"score_name": "score_a"}]
            line = json.dumps(rec)
            fh.write(ammo_sample.format(n_bytes=len(line) + 1, data=line))
            if idx % 100 == 0:
                print('.')
            # if idx > 1000:
                # break


if __name__ == '__main__':
    yt_client = yt_utils.get_yt_client()
    input_table = '//projects/scoring/tmp/re9ulusv/tables-to-transfer-ydb/sample-request-ids'
    out_file = 'test.ammo'
    generate_ammo(yt_client, input_table, out_file)
