# -*- coding: utf-8 -*-
from textwrap import dedent
from datacloud.dev_utils.transfer.yt_to_ydb import table_description


__all__ = [
    'schema',
    'fields',
    'ScoreTableDescription'
]


schema = dedent("""\
    (
    hashed_id Uint64,
    score Double,
    primary key (hashed_id)
    )
""")


fields = dedent("""\
    hashed_id,
    score
""")


class ScoreTableDescription(table_description.YdbTableDescription):
    def __init__(self, table_path, ydb_connection_params):
        super(ScoreTableDescription, self).__init__(table_path, ydb_connection_params)
        self.schema = schema
        self.fields = fields
