# -*- coding: utf-8 -*-
from textwrap import dedent
from datacloud.dev_utils.yql import yql_helpers


__all__ = [
    'YdbTableDescription',
    'YdbConnectionParams',
    'YtTableDescription'
]


class YdbConnectionParams(object):

    __slots__ = ('endpoint', 'database')

    def __init__(self, endpoint, database):
        self.endpoint = endpoint
        self.database = database


class TableDescription(object):
    def __init__(self, table_path):
        self.path = table_path


class YdbTableDescription(TableDescription):
    def __init__(self, table_path, ydb_connection_params):
        super(YdbTableDescription, self).__init__(table_path)
        self.connection_params = ydb_connection_params
        self.schema = None
        self.fields = None

    def drop(self, yql_client):
        query = self._drop_request.format(ydb_table=self)
        request = yql_client.query(query).run()

        if not request.is_success:
            raise yql_helpers.YqlExecutionException((request.status, list(map(str, request.errors))))

    _drop_request = dedent("""\
        USE [{ydb_table.connection_params.database}];
        DROP TABLE [{ydb_table.path}]
    """)


class YtTableDescription(TableDescription):
    def __init__(self, table_path, yt_cluster):
        super(YtTableDescription, self).__init__(table_path)
        self.yt_cluster = yt_cluster
