from yql.api.v1.client import YqlClient
from datacloud.dev_utils.transfer.yt_to_ydb import table_description
from datacloud.dev_utils.yql import yql_requests, yql_helpers
from datacloud.config.yt import YT_PROXY


__all__ = [
    'transfer',
    'create_table'
]


def create_table(yql_client, ydb_table_description):
    yql_helpers.execute_yql(
        yql_requests.create_ydb_table.format(ydb_table=ydb_table_description),
        yql_client,
        syntax_version=1,
    )


def transfer(yql_client, yt_table_description, ydb_table_description, ydb_token):
    yql_helpers.execute_yql(
        yql_requests.transfer_yt_table_to_ydb.format(
            yt_cluster=yt_table_description.yt_cluster,
            yt_table=yt_table_description,
            ydb_table=ydb_table_description,
            ydb_token=ydb_token,
        ),
        yql_client,
        syntax_version=1,
    )


def sample_transfer(yql_token):
    yql_client = YqlClient(db=YT_PROXY, token=yql_token)

    ydb_connection_params = table_description.YdbConnectionParams(
        endpoint='ydb-ru.yandex.net:2135',
        database='/ru/impulse/production/xprod-scoring-api-db'
    )

    source_table = table_description.YtTableDescription(
        table_path='//projects/scoring/tmp/re9ulusv/tables-to-transfer-ydb/ubrr/encoded_meta_score_v2',
        yt_cluster=YT_PROXY
    )
    target_table = table_description.YdbScoreTableDescription(
        table_path='/ru/impulse/production/xprod-scoring-api-db/score_api/scores/ubrr/ubrr_xprod_1158_socdef/date-2019-01-24/score',
        ydb_connection_params=ydb_connection_params
    )
    transfer(yql_client, source_table, target_table, yql_token)
