# -*- coding: utf-8 -*-
import os


__all__ = [
    'YDB_ENDPOINT',
    'YDB_DATABASE',
    'YDB_ROOT',
    'YDB_LOCK_NAME'
]

if os.environ.get('IS_YDB_DEBUG', False):
    YDB_ENDPOINT = 'ydb-ru-prestable.yandex.net:2135'
    YDB_DATABASE = '/ru-prestable/impulse/test/xprod-scoring-api-db'
    YDB_ROOT = os.path.join(YDB_DATABASE, 'sandbox_score_api')
else:
    YDB_ENDPOINT = 'ydb-ru.yandex.net:2135'
    YDB_DATABASE = '/ru/impulse/production/xprod-scoring-api-db'
    YDB_ROOT = os.path.join(YDB_DATABASE, 'score_api')


YDB_LOCK_NAME = 'ydbtransfer'
