# -*- coding: utf-8 -*-
import os
import yt.wrapper as yt_wrapper


__all__ = [
    'DatabaseInfo',
    'DEV'
]


class DatabaseInfo(object):
    def __init__(self, ydb_endpoint, ydb_database, ydb_root,
                 yt_cluster='hahn', yt_root=None):
        self.ydb_endpoint = ydb_endpoint
        self.ydb_database = ydb_database
        self.ydb_root = ydb_root
        self.yt_cluster = yt_cluster
        self.yt_root = yt_root

    def get_ydb_table_path(self, harvesting):
        return os.path.join(self.ydb_root, harvesting.rel_path)

    def get_ydb_table_folder(self, harvesting):
        table_path = self.get_ydb_table_path(harvesting)
        return '/'.join(table_path.split('/')[:-1])

    def get_yt_table_path(self, harvesting):
        self._check_yt_presence()
        return yt_wrapper.ypath_join(self.yt_root, harvesting.table_path)

    @property
    def is_yt_available(self):
        return self.yt_cluster is not None and self.yt_root is not None


DEV = DatabaseInfo(
    'ydb-ru-prestable.yandex.net:2135',
    '/ru-prestable/impulse/prestable/xprod-scoring-api-db',
    'recipe-testing-api'
)

PROD = DatabaseInfo(
    'ydb-ru.yandex.net:2135',
    '/ru/impulse/production/xprod-scoring-api-db',
    'score_api'
)

SANDBOX = DatabaseInfo(
    'ydb-ru-prestable.yandex.net:2135',
    '/ru-prestable/impulse/prestable/xprod-scoring-api-db',
    'sandbox_score_api'
)

TESTING = DatabaseInfo(
    'ydb-ru-prestable.yandex.net:2135',
    '/ru-prestable/impulse/test/xprod-scoring-api-db',
    'test_score_api'
)
