# -*- coding utf-8 -*-
from datacloud.score_api.storage.ydb.ydb_tables.config_tables.partner_scores_table import PartnerScoresTable
from datacloud.score_api.storage.ydb.ydb_tables.config_tables.partner_tokens_table import PartnerTokensTable
from datacloud.score_api.storage.ydb.ydb_tables.config_tables.score_path_table import ScorePathTable
from datacloud.score_api.storage.ydb.ydb_tables.config_tables.geo_path_table import GeoPathTable

from datacloud.score_api.storage.ydb.ydb_tables.stability_tables.stability_table import StabilityTable
from datacloud.score_api.storage.ydb.ydb_tables.rejected_tables.rejected_requests_table import RejectedRequestsTable
from datacloud.score_api.storage.ydb.ydb_tables.score_tables.score_table import MetaScoreTable


__all__ = [
    'Harvesting',
    'HarvestingGroup',
    'CONFIG',
    'STABILITY',
    'REJECT',
    'SANDBOX',
]


class Harvesting(object):
    def __init__(self, ydb_cls, rel_path):
        self.ydb_cls = ydb_cls
        self.rel_path = rel_path

    def __repr__(self):
        return '{} {}'.format(self.ydb_cls, self.rel_path)

    def __str__(self):
        return self.__repr__()


class HarvestingGroup(object):
    def __init__(self, harvesting_items):
        self._items = harvesting_items
        self._idx = 0

    def __iter__(self):
        return HarvestingGroup(self._items)  # self

    def next(self):
        if self._idx == len(self._items):
            raise StopIteration
        item = self._items[self._idx]
        self._idx += 1
        return item


CONFIG = HarvestingGroup([
    Harvesting(PartnerScoresTable, 'config/partner_scores'),
    Harvesting(PartnerTokensTable, 'config/partner_tokens'),
    Harvesting(ScorePathTable, 'config/score_path')
])

STABILITY = HarvestingGroup([
    Harvesting(StabilityTable, 'stability/stability')
])

REJECT = HarvestingGroup([
    Harvesting(RejectedRequestsTable, 'rejected/rejected_requests')
])

GEO = HarvestingGroup([
    Harvesting(GeoPathTable, 'config/geo_path'),
    Harvesting(ScorePathTable, 'config/partner_linears')
])

SANDBOX = HarvestingGroup([
    Harvesting(MetaScoreTable, 'scores/partner_a/score_a/2019-03-21/score'),
    Harvesting(MetaScoreTable, 'scores/partner_a/score_b/2019-03-21/score'),
    Harvesting(MetaScoreTable, 'scores/partner_a/score_c/2019-03-21/score'),
])
