import yt.wrapper as yt_wrapper
from datacloud.dev_utils.ydb.lib.deploy import (
    db_information, harvesting, record_storage)


__all__ = [
    'Recipe',
    'SANDBOX_DATA',
    'SANDBOX_CONFIG'
]


class Recipe(object):
    def __init__(self, db_info, harvesting_group, data_source=None):
        self.harvesting_group = harvesting_group
        self.db_info = db_info
        self.data_source = data_source


# --- TODO: Move to score_api
_sandbox_data_source = record_storage.Yt(
    yt_wrapper,
    '//home/x-products/production_sandbox/ydb_sandbox/sandbox_score_api'
)


SANDBOX_DATA = Recipe(
    db_information.SANDBOX,
    harvesting.SANDBOX,
    _sandbox_data_source
)

SANDBOX_CONFIG = Recipe(
    db_information.SANDBOX,
    harvesting.CONFIG,
    _sandbox_data_source
)

PROD_CONFIG = Recipe(
    db_information.PROD,
    harvesting.CONFIG
)

PROD_GEO = Recipe(
    db_information.PROD,
    harvesting.GEO
)
