import os
import yt.wrapper as yt_wrapper
from datacloud.dev_utils.ydb.lib.deploy import (
    recipe, record_storage, deploy_manager)
from datacloud.dev_utils.ydb.lib.core.ydb_manager import(
    YdbManager, YdbConnectionParams)


def deploy_sandbox():
    token = os.environ['YDB_TOKEN']
    db_info = recipe.SANDBOX_CONFIG.db_info
    yt_wrapper.config.set_proxy(db_info.yt_cluster)

    connection_params = YdbConnectionParams(
        endpoint=db_info.ydb_endpoint,
        database=db_info.ydb_database,
        auth_token=token
    )

    assert 'prestable' in db_info.ydb_endpoint or 'test' in db_info.ydb_endpoint, 'Please check that you use testing db'

    manager = YdbManager(connection_params)
    deployer = deploy_manager.Deployer(manager, db_info.ydb_database)

    deployer.deploy(recipe.SANDBOX_DATA)
    deployer.deploy(recipe.SANDBOX_CONFIG)
    deployer.fill(recipe.SANDBOX_DATA)
    deployer.fill(recipe.SANDBOX_CONFIG)


def dump_prod_config():
    token = os.environ['YDB_TOKEN']
    db_info = recipe.PROD_CONFIG.db_info
    yt_wrapper.config.set_proxy(db_info.yt_cluster)

    connection_params = YdbConnectionParams(
        endpoint=db_info.ydb_endpoint,
        database=db_info.ydb_database,
        auth_token=token
    )

    manager = YdbManager(connection_params)
    deployer = deploy_manager.Deployer(manager, db_info.ydb_database)
    storage = record_storage.Memory()

    # To backup on YT
    # storage = record_storage.Yt(yt_wrapper, '//projects/scoring/tmp/re9ulusv/ydb-backup')

    deployer.dump(recipe.PROD_CONFIG, storage)
    print('Storage data is: {}'.format(storage._data))


def main():
    # deploy_sandbox()
    dump_prod_config()


if __name__ == '__main__':
    main()
