from textwrap import dedent

__all__ = [
    'transfer_yt_table_to_ydb',
    'create_ydb_table'
]


transfer_yt_table_to_ydb = dedent("""\
    $ydb_endpoint = "{ydb_table.connection_params.endpoint}";
    $ydb_database = "{ydb_table.connection_params.database}";
    $ydb_table = "{ydb_table.path}";
    $ydb_batch_size_bytes = 5242880;
    $ydb_batch_size_rows = 10000;
    $ydb_max_retries = 10000;
    $ydb_retry_wait_time_sec = 1;

    PRAGMA yt.DataSizePerJob = "600000000";
    PRAGMA yt.UserSlots = "3";

    SELECT
        SUM(Bytes) AS TotalBytes,
        SUM(Rows) AS TotalRows,
        SUM(Batches) AS TotalBatches,
        SUM(Retries) AS TotalRetries
    FROM (
        PROCESS (
            SELECT
                {ydb_table.fields}
            FROM hahn.`{yt_table.path}` as t
        )
        USING YDB::PushData(
            TableRows()
            , $ydb_endpoint
            , $ydb_database
            , $ydb_table
            , AsTuple("unsecure", "{ydb_token}")
            , $ydb_batch_size_bytes
            , $ydb_batch_size_rows
            , $ydb_max_retries
        )
    );
""")


create_ydb_table = dedent("""\
    USE `{ydb_table.connection_params.database}`;

    CREATE TABLE `{ydb_table.path}`
    {ydb_table.schema};
    COMMIT;
""")
