# Описание принципов рассчета признаков
Практически все признаки считаются на основе spy и watch логах, которые мы собираем на своей стороне для пользователей с crypta_id, у которых есть телефон или имэйл в идентификаторах. Логи приводятся к определенному виду и храняться тут: (https://yt.yandex-team.ru/hahn/navigation?path=//home/x-products/production/datacloud/grep&). При построении признаков, идентификаторы пользователя матчатся в один или несколько crypta_id, а crypta_id в свою очередь в yuid'ы. На собранные yuid собираются логи.

`dssm:`
Считается на основе spylog и watchlog.
Мы взяли обученную DSSM-модель, которая используется в поиске. Модель обучалась на поисковой выдаче/разметке асессоров для того, чтобы по запросу подбирать релевантные страницы. 

Для каждого запроса пользователя из spy и watch логов оценивается релевантность по отношению к некоторому набору n-грамм, которые определялись перебором из экспертного пула и пула n-грамм людей с просрочкой. Всего таких n-грамм 400 и лежат они тут (https://arcanum.yandex-team.ru/arc/trunk/arcadia/datacloud/features/dssm/query_vectors.txt) вместе со своими векторами эмбеддингов. Релевантность оценивалась как косинусное расстояние эмбедингов title + url к эмбеддингам референсных фраз.

Таким образом, для каждого перехода пользователя в логах есть вектор из 400 элементов. Для пользователя эти вектора аггрегируются через максимум. Т.е. оценивается насколько релевантна была каждая конкретная n-gram для данного пользователя за последние 180 дней. Таким образом пользователю ставится в соответствие вектор из 400 элементов.

`site2vec:`
Считается на основе spylog и watchlog.
Отдел крипты для каждого хоста строит вектора (aka word2vec, размерности 512, обладающие свойством группировки похожих хостов, например вектора сайтов gazeta.ru и rbc.ru будут близки). Таблицу с такими векторами мы фиксировали (https://yt.yandex-team.ru/hahn/navigation?path=//home/x-products/production/datacloud/bins/site2vec_04.04.2017&). Для каждого пользователя считается средний вектор уникальных посещенных хостов за последние 180 дней. Полученный вектор для пользователя нормируется на 1 норму (проекция на сферу).

`cluster:`
Считается на основе spylog и watchlog.
Кластерные признаки. Используются только в старых моделях, так как не обладают каким-либо преимуществом над site2vec признаками, кроме некоторой интерпретируемости, при этом считаются сложнее, так как требуют дополнительный шаг.

В Я.Каталоге хосты представлены в нескольких категориях (https://yandex.ru/yaca/), мы выбрали 763 категории + 4 категории предоставил партнер банк.

Представим категорию одним кластером, у которого найдём центр как средний вектор входящих в категорию хостов. (https://yt.yandex-team.ru/hahn/navigation?path=//home/x-products/production/datacloud/bins/yandex_catalog_hosts_v1&)
Теперь от site2vec вектора пользователя посчитаем косинусное расстояния до центров кластеров, т.о. представив каждого пользователя характеристическим вектором, обозначающим его близость к каждой из 767 категорий.

В результате пользователь описывается с помощью 767 признаками обозначающих его интерес за 180 дней к данной категории. Имена категорий можно воспользовавшись специальной утилитой в ml_utils/feature_selection/features_name.py

`contact_actions:`
Считается только на основе watchlog. Берутся все события перехода пользователя на чей-то контакт (tel:..., mailto:..., tg:...). Сохраням также реферер (url и title) для описания страницы, с которой осуществлен переход на контакт.
Берется история переходов на контакт пользователя за 720 дней и считаются булевы признаки принадлежности рефереров к категориям.
Пока в контактах используются только категории из сайта avito (50 категорий).
Семантика признаков получается вида: была ли анкета о продаже авто на авито за последние 720 дней (и кто-то переходил по этому контакту), о поиске работы, ...



`time_hist:`
Считается на основе spylog и watchlog.
Сначала вычисляется часовой пояс пользователя из кликстрима.
Для каждого часа считается отношение дней, когда у пользователя были события в этот час, к общему количеству дней с событиями за последние 175 дней.
Получается гистограма активности по часам. Такая гистограмма строится отдельно для рабочих и выходных дней.


`phone_range:`
Описание диапазона, которому принадлежит номер телефона в виде кода оператора и кода региона. Список диапазонов фиксированный с сайта россвязи. Замена оператора никак не учитывается.
Если посчитаны признаки `time_hist`, то можно посчитать флаг наличия расхождения в часовых поясах по кликстриму и по региону.

`geo`
Признаки считаются, если партнер передает гео точки пользователя: адрес регистрации, адрес фактического проживания, адрес работы. Суть признака это понять, есть ли переданные пользователем точки в его регулярных координатах. Всего рассчитываются 18 признаков: 3 признака - бинарные признаки того, что пользовательский адрес удалось разрешить в координаты. Остальные 5 бинарных признаков - находятся ли 5 ближайших регулярных координат пользователя к указанной точке в окресности 500 метров.