from datacloud.dev_utils.yt import yt_utils
from datacloud.features.cluster import clust_features


def step1(yt_client, config, date):
    clust_features.step_1_daily_hostnames_extract(
        yt_client=yt_client, date=date, path_config=config
    )


def step2(yt_client, config, date):
    clust_features.step_2_bow_reducer(
        date=date,
        yt_client=yt_client,
        path_config=config
    )


def step3(yt_client, config, date):
    clust_features.step_3_build_user2host(
        date=date,
        yt_client=yt_client,
        path_config=config
    )


def step4(yt_client, config, date):
    clust_features.step_4_build_user2clust(
        date=date,
        yt_client=yt_client,
        path_config=config
    )


def main():
    date = 'learn'
    yt_client = yt_utils.get_yt_client()
    config = clust_features.PathConfig(
        root='//projects/scoring/vtb/XPROD-1730-reproduce',
        date=date,
        is_retro=True,
        retro_tag='-r9-reproduce-cluster',
    )
    for step in (step1, step2, step3, step4):
        step(yt_client, config, date)


if __name__ == '__main__':
    main()
