from util.generic.string cimport TString
from util.generic.vector cimport TVector

cdef extern from "datacloud/features/cluster/fast_clust.h" namespace "Datacloud::Features::Cluster" nogil:
    void FastYuidToCid(
        const TString& ytToken, const TString& cluster,
        const TString& yuidToCidTable, const TVector[TString]& urlTables,
        const TString& outputTable) nogil

    void FastHostnameBow(
        const TString& ytToken, const TString& cluster,
        const TVector[TString]& inputTables, const TString ouptutTable) nogil

    void FastAppendHostVectorReducer(
        const TString& ytToken, const TString& cluster,
        const TString& hostToVectorTable, const TString& keyToHostTable,
        const TString& outputTable) nogil

    void FastUserVectorReducer(
        const TString& ytToken, const TString& cluster,
        const TString& inputTable, const TString& outputTable) nogil


cdef _fast_yuid_to_cid(
    const TString& ytToken, const TString& cluster,
    const TString& yuidToCidTable, const TVector[TString]& urlTables,
    const TString& outputTable):
    with nogil:
        FastYuidToCid(ytToken, cluster, yuidToCidTable, urlTables, outputTable)


def fast_yuid_to_cid(ytToken, cluster, yuidToCidTable, urlTables, outputTable):
    _fast_yuid_to_cid(ytToken, cluster, yuidToCidTable, urlTables, outputTable)


cdef _fast_hostname_bow(
    const TString& ytToken, const TString& cluster,
    const TVector[TString]& inputTables, const TString& outputTable):
    with nogil:
        FastHostnameBow(ytToken, cluster, inputTables, outputTable)


def fast_hostname_bow(ytToken, cluster, inputTables, outputTable):
    _fast_hostname_bow(ytToken, cluster, inputTables, outputTable)


cdef _fast_append_host_vector_reducer(
    const TString& ytToken, const TString& cluster,
    const TString& hostToVectorTable, const TString& keyToHostTable,
    const TString& outputTable):
    with nogil:
        FastAppendHostVectorReducer(
            ytToken, cluster, hostToVectorTable, keyToHostTable, outputTable)


def fast_append_host_vector_reducer(
    ytToken, cluster, hostToVectorTable, keyToHostTable, outputTable):
    _fast_append_host_vector_reducer(
        ytToken, cluster, hostToVectorTable, keyToHostTable, outputTable)


cdef _fast_user_vector_reducer(
    const TString& ytToken, const TString& cluster,
    const TString& inputTable, const TString& outputTable):
    with nogil:
        FastUserVectorReducer(ytToken, cluster, inputTable, outputTable)


def fast_user_vector_reducer(
    ytToken, cluster, inputTable, outputTable):
    _fast_user_vector_reducer(ytToken, cluster, inputTable, outputTable)
